{% from slspath ~ "/map.jinja" import genbackup with context %}
{% if genbackup.dbms == 'mongodb' %}
{% from "components/mongodb/map.jinja" import mongodb as dbms with context %}
{% endif %}
{% set dbms_user = dbms.user %}
{% set gpg_user = dbms.user %}
{% set gpg_group = dbms.group %}
{% set gpg_homedir = dbms.homedir %}
{% set s3cmd_conf = genbackup.confdir + '/s3cmd.conf' %}

{{gpg_homedir}}/.gnupg:
    file.directory:
        - user: {{gpg_user}}
        - group: {{gpg_group}}
        - makedirs: True
        - mode: 700

{% if not salt['pillar.get']('data:s3:gpg_key', False) %}
{% for file in ['pubring.gpg', 'secring.gpg', 'trustdb.gpg'] %}
{{gpg_homedir}}/.gnupg/{{file}}.base64:
    file.managed:
        - contents_pillar: {{file}}
        - user: {{gpg_user}}
        - group: {{gpg_group}}
        - mode: 600
        - require:
            - file: {{gpg_homedir}}/.gnupg
install-{{file|replace('.', '-')}}:
    cmd.wait:
        - shell: /bin/bash
        - runas: {{gpg_user}}
        - umask: 077
        - require:
            - file: {{gpg_homedir}}/.gnupg/{{file}}.base64
        - require_in:
            - file: {{s3cmd_conf}}
        - watch:
            - file: {{gpg_homedir}}/.gnupg/{{file}}.base64
        - name: |
            openssl enc -base64 -d -in {{gpg_homedir}}/.gnupg/{{file}}.base64 -out {{gpg_homedir}}/.gnupg/{{file}}
{% endfor %}
{% else %}
{{ gpg_homedir }}/.gnupg/key.armor:
    file.managed:
        - contents_pillar: 'data:s3:gpg_key'
        - user: {{gpg_user}}
        - group: {{gpg_user}}
        - mode: 600
        - require:
            - file: {{ gpg_homedir }}/.gnupg

drop-existing-keyrings:
    cmd.wait:
        - name: rm -rf {{ gpg_homedir }}/.gnupg/*.gpg*
        - watch:
            - file: {{ gpg_homedir }}/.gnupg/key.armor
        - require_in:
            - file: {{s3cmd_conf}}

import-gpg-key:
    cmd.wait:
        - runas: {{gpg_user}}
        - name: gpg --no-tty --import {{ gpg_homedir }}/.gnupg/key.armor
        - watch:
            - cmd: drop-existing-keyrings
        - require_in:
            - file: {{s3cmd_conf}}

trust-all-imported-keys:
    cmd.wait:
        - runas: {{gpg_user}}
        - use_vt: True
        - name: for key in $(gpg -k | grep ^pub | cut -d'/' -f2 | awk '{print $1};' 2>/dev/null); do printf "trust\n5\ny\nquit" | gpg --debug --no-tty --command-fd 0 --edit-key ${key}; done
        - watch:
            - cmd: import-gpg-key
        - require_in:
            - file: {{s3cmd_conf}}
{% endif %}

