{% from slspath ~ "/map.jinja" import genbackup with context %}
{% if genbackup.dbms == 'mongodb' %}
{% from "components/mongodb/map.jinja" import mongodb as dbms with context %}
{% endif %}
{% set dbms_user = dbms.user %}

genbackup-packages:
    pkg.installed:
        - pkgs:
            - genbackup: {{genbackup.version}}
            - python3.5: 3.5.2-3yandex2
            - pv
            - zk-flock
            - python-kazoo: 2.2.1-yandex1
            - python3-yaml: 3.10-4ubuntu0.1

{% if genbackup.get('zk_hosts') %}
{% for rname, rpath in genbackup.zk_root.items() %}
genbackup-zk-root-{{rname}}:
    zookeeper.present:
        - name: {{ rpath }}
        - value: ''
        - makepath: True
        - hosts: {{ genbackup.zk_hosts }}
        - require:
            - pkg: genbackup-packages

{{genbackup.confdir}}/zk-flock-{{rname}}.json:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/zk-flock.json
        - defaults:
            zk_hosts: {{ genbackup.zk_hosts}}
            zk_root: {{ rpath }}
        - mode: 644 
        - makedirs: True
        - require:
            - pkg: genbackup-packages
{% endfor %}
{% endif %}

{{genbackup.confdir}}:
    file.directory:
        - user: root
        - group: root
        - mode: 755 
        - makedirs: True

{{genbackup.confdir}}/genbackup.conf:
    file.managed:
        - source: salt://{{ slspath }}/conf/{{genbackup.dbms}}-backup.conf
        - template: jinja
        - user: root
        - group: {{dbms_user}}
        - mode: 640 
        - require:
            - pkg: genbackup-packages
            - file: {{genbackup.confdir}}
        - require_in:
            - file: /etc/cron.d/genbackup

{{genbackup.confdir}}/s3cmd.conf:
    file.managed:
        - source: salt://{{ slspath }}/conf/s3cmd.conf
        - template: jinja
        - user: root
        - group: s3users
        - mode: 640
        - require:
            - file: {{genbackup.confdir}}
        - require_in:
            - file: /etc/cron.d/genbackup

/etc/cron.d/genbackup:
    file.managed:
        - source: salt://{{ slspath }}/conf/genbackup.cron
        - template: jinja
        - mode: 644

/etc/logrotate.d/genbackup:
    file.managed:
        - source: salt://{{ slspath }}/conf/genbackup.logrotate
        - mode: 644 
        - require:
            - file: /etc/cron.d/genbackup

{{genbackup.logdir}}:
    file.directory:
        - user: root
        - group: {{dbms_user}}
        - mode: 755 
        - makedirs: True
        - require_in:
            - file: /etc/cron.d/genbackup

s3users:
    group.present:
        - members:
            - {{dbms_user}}
            - monitor
        - system: True
        - require:
            - pkg: yamail-monrun
        - watch_in:
            - service: snaked
            - service: juggler-client

initial-genbackup:
    cmd.run:
        - name: zk-flock -c {{genbackup.confdir}}/zk-flock-backup.json lock "timeout 610m /usr/bin/genbackup backup"
        - unless:
            - genbackup list | grep -qP "^\d+T\d+"
        - env:
            - LC_ALL: C.UTF-8
            - LANG: C.UTF-8
        - require:
            - pkg: genbackup-packages
            - file: /etc/yandex/genbackup/genbackup.conf
            - file: {{genbackup.logdir}}
            - file: {{genbackup.confdir}}/zk-flock-backup.json
            - zookeeper: genbackup-zk-root-backup
            - file: /etc/cron.d/genbackup
{% if genbackup.dbms == 'mongodb' %}
{% for srv in dbms.services_deployed %}
            - mongodb: add-admin-user-{{srv}}
            - mongodb: {{srv}}-service
{% endfor %}
{% endif %}
