graphite-packages-docdb:
    pkg.installed:
        - pkgs:
            - yandex-graphite-checks-system: 1.0-15
            - yabs-graphite-sender: 0.2.48-3341599
            - yabs-graphite-sender-config-corba: 0.7

yandex-graphite-checks-system-conf:
    file.managed:
        - name: /etc/graphite-checks.conf
        - source: salt://components/graphite/docdb/yandex-graphite-checks-system.conf
        - template: jinja
        - watch:
            - pkg: graphite-packages-docdb

mongo_stat.py:
    file.managed:
        - name: /usr/lib/yandex-graphite-checks/available/mongo_stat.py
        - source: salt://components/graphite/docdb/mongo_stat.py
        - mode: 755
        - require:
            - pkg: graphite-packages-docdb

mongo_stat.py_enabled:
    file.symlink:
        - name: /usr/lib/yandex-graphite-checks/enabled/mongo_stat.py
        - target: /usr/lib/yandex-graphite-checks/available/mongo_stat.py
        - require:
            - file: mongo_stat.py
