#!/usr/bin/python
import re
from pymongo import MongoClient

def to_snake_case(value):
    intermediate = value.replace(' ', '_').replace('-', '_')
    intermediate = re.sub('(.)([A-Z][a-z]+)', r'\1_\2', intermediate)
    return re.sub('([a-z0-9])([A-Z])', r'\1_\2', intermediate).lower()

def print_stat(name, value):
    if isinstance(value, (bool, float)):
        print_stat(name, int(value))
    elif isinstance(value, (int, long, str)):
        print '%s %s' % (to_snake_case(name), value)
    elif isinstance(value, dict):
        for k, v in value.iteritems():
            print_stat(name + '.' + k, v)
    else:
        raise NotImplementedError(name)

def print_server_status(value):
    print_stat('uptime', value['uptime'])
    print_stat('connections.current', value['connections']['current'])
    print_stat('connections.available', value['connections']['available'])
    print_stat('network.bytesIn', value['network']['bytesIn'])
    print_stat('network.bytesOut', value['network']['bytesOut'])
    print_stat('network.numRequests', value['network']['numRequests'])
    print_stat('opcounters', value['opcounters'])
    print_stat('opcountersRepl', value['opcountersRepl'])
    print_stat('repl.ismaster', value['repl']['ismaster'])
    print_stat('wiredTiger.cache', value['wiredTiger']['cache'])
    print_stat('mem.resident', value['mem']['resident'])
    print_stat('mem.virtual', value['mem']['virtual'])

def print_collection_stats(name, value):
    print_stat(name + '.count', value['count'])
    print_stat(name + '.size', value['size'])
    print_stat(name + '.avgObjSize', value.get('avgObjSize', 0))
    print_stat(name + '.storageSize', value['storageSize'])
    print_stat(name + '.totalIndexSize', value['totalIndexSize'])
    print_stat(name + '.wiredTiger.cache.bytes read into cache', value['wiredTiger']['cache']['bytes read into cache'])
    print_stat(name + '.wiredTiger.cache.bytes written from cache', value['wiredTiger']['cache']['bytes written from cache'])
    for index, detail in value['indexDetails'].iteritems():
        print_stat(name + '.index.' + index + '.cache.bytes read into cache', detail['cache']['bytes read into cache'])
        print_stat(name + '.index.' + index + '.cache.bytes written from cache', detail['cache']['bytes written from cache'])
        print_stat(name + '.index.' + index + '.size', value['indexSizes'][index])

with open('/root/.password', 'r') as pwfile:
    password = pwfile.read().strip()
mongo = MongoClient('mongodb://admin:%s@localhost:27018' % password)
print_server_status(mongo.randomdb.command('serverStatus'))

database_names = mongo.database_names()
for database_name in database_names:
    db = mongo[database_name]
    collection_names = db.collection_names()
    for collection_name in collection_names:
        print_collection_stats('database.' + database_name.replace('.', '_') + '.collection.' + collection_name.replace('.', '_'), db.command('collStats', collection_name))
