{% if salt['pillar.get']('data:report_to_graphite', True) %}
yandex-graphite-checks-system-package:
    pkg.installed:
        - pkgs:
{% if salt['grains.get']('os') == 'Ubuntu' %}
            - yandex-graphite-checks-system: 1.0-15
            - yabs-graphite-client: 0.2.30
{% else %}
            - yandex-graphite-checks-system: 3.9.4-8
{% endif %}

yandex-graphite-checks-cron:
    file.managed:
{% if salt['grains.get']('os') == 'Ubuntu' %}
        - name: /etc/cron.d/yabs-graphite-client
{% else %}
        - name: /etc/cron.d/graphite-client
{% endif %}
        - source: salt://components/graphite/pg/yandex-graphite-checks-cron.d
        - template: jinja
        - watch:
            - pkg: yandex-graphite-checks-system-package
        - watch_in:
            - service: pg-common-configs-crond-reload

pg-graphite-scripts-dir:
    file.directory:
        - name: /usr/share/graphite-client
        - makedirs: True

pg-graphite-scripts:
    file.recurse:
        - name: /usr/share/graphite-client/checks
        - file_mode: '0755'
        - template: jinja
        - source: salt://{{ slspath }}/scripts
        - include_empty: True
        - watch:
            - pkg: yandex-graphite-checks-system-package
            - file: pg-graphite-scripts-dir
{% else %}
yandex-graphite-checks-system-package:
    pkg.purged:
        - pkgs:
{% if salt['grains.get']('os') == 'Ubuntu' %}
            - yandex-graphite-checks-system
            - yabs-graphite-client
{% else %}
            - yandex-graphite-checks-system
{% endif %}

yandex-graphite-checks-cron:
    file.absent:
{% if salt['grains.get']('os') == 'Ubuntu' %}
        - name: /etc/cron.d/yabs-graphite-client
{% else %}
        - name: /etc/cron.d/graphite-client
{% endif %}

pg-graphite-scripts-dir:
    file.absent:
        - name: /usr/share/graphite-client
{% endif %}
