#!/bin/sh

hn=$(hostname -f | sed -e 's/\./_/g')
ts=$(/bin/date +%s)
prefix="{{ salt['grains.get']('domain', 'mail.yandex.net').split('.')[0].replace('cmail', 'mail') }}.pg.${hn}.os.disk_usage"

{% if salt['grains.get']('os') == 'Ubuntu' %}
pg_prefix='/var/lib/postgresql'
{% else %}
pg_prefix='/var/lib/pgsql'
{% endif %}
for p in $(mount -l | grep "$pg_prefix" | awk '{print $3};')
do
    dusage=$(df "${p}" 2>/dev/null | grep "${p}" | awk '{ print $5 }' | grep -Eo '[0-9]*')
    fsname=${p##*/}

    if [ -n "${fsname}" ] && [ -n "${dusage}" ]; then
        echo "$prefix.${fsname} ${dusage} ${ts}"
    fi
done

wal_count=$(ls -1 $pg_prefix/9.*/data/pg_xlog | grep -cvE "history|archive_status")

echo "$prefix.wal_files ${wal_count} ${ts}"
