#!/bin/sh

ts=$(date +%s)
hn=$(hostname)
hn=$(echo "${hn}" | tr '.' '_')

prefix="{{ salt['grains.get']('domain', 'mail.yandex.net').split('.')[0].replace('cmail', 'mail') }}.pg.pgbouncer.host.${hn}"

/usr/bin/timeout 5 /usr/bin/psql -t "host=localhost port=6432 dbname=pgbouncer user=monitor" -c "show lists" | sed 's/\s|\s/\ /g' |\
while read k v
do
    if [ -z "$k" ]; then
        continue
    fi

    if ! ([ "$k" = "free_clients" ] || [ "$k" = "used_clients" ] || [ "$k" = "free_servers" ] || [ "$k" = "used_servers" ]); then
        continue
    fi

    echo "$prefix.$k $v $ts"
done

/usr/bin/timeout 5 /usr/bin/psql -t "host=localhost port=6432 dbname=pgbouncer user=monitor" -c "show pools" | sed 's/\s|\s/\ /g' |\
while read db user cl_active cl_waiting sv_active sv_idle sv_used sv_tested sv_login maxwait
do
    if [ -z "$db" ]; then
        continue;
    fi

    udb=".pool.$db.user.$user."

    echo "$prefix$udb"cl_active "$cl_active $ts"
    echo "$prefix$udb"cl_waiting "$cl_waiting $ts"
    echo "$prefix$udb"sv_active "$sv_active $ts"
    echo "$prefix$udb"sv_idle "$sv_idle $ts"
    echo "$prefix$udb"sv_used "$sv_used $ts"
    echo "$prefix$udb"sv_tested "$sv_tested $ts"
    echo "$prefix$udb"sv_login "$sv_login $ts"
    echo "$prefix$udb"maxwait "$maxwait $ts"
done

/usr/bin/timeout 5 /usr/bin/psql -t "host=localhost port=6432 dbname=pgbouncer user=monitor" -c "show stats" | sed 's/\s|\s/\ /g' |\
while read db total_requests _ _ _ _ _ _ avg_query
do
    if [ -z "$db" ]; then
        continue;
    fi

    echo "$prefix.pool.$db.total_requests $total_requests $ts"
    echo "$prefix.pool.$db.avg_query $avg_query $ts"
done

exit 0
