#!/bin/sh

{% if salt['grains.get']('os') == 'Ubuntu' %}
pg_prefix='/var/lib/postgresql'
{% else %}
pg_prefix='/var/lib/pgsql'
{% endif %}

if [ ! -f $pg_prefix/9.*/data/recovery.conf ]
then
    exit 0
fi

export s_host=`hostname -f`
export s_port=5432
export p_db=postgres
export psql=/usr/bin/psql

ts=`/bin/date +%s`
hn=`/bin/hostname -f | tr '.' '_'`

lag=$($psql -U monitor -h$s_host -p$s_port -A -t -c "select extract(epoch from (current_timestamp - ts)) as replication_lag from repl_mon;" $p_db 2>/dev/null)

echo "{{ salt['grains.get']('domain', 'mail.yandex.net').split('.')[0].replace('cmail', 'mail') }}.pg."${hn}".db.replica_lag "${lag}" "${ts}
