#!/usr/bin/env python

import socket
import time
import sys
import psycopg2
import os

me = sys.argv[0].split('/')[-1].split('.')[0]
hostname = socket.gethostname()
hostname_s = hostname.replace('.', '_')
current_ts = int(time.time())
gr_prefix = "{{ salt['grains.get']('domain', 'mail.yandex.net').split('.')[0].replace('cmail', 'mail') }}.pg"

metrics = ['active', 'idle']

user = 'monitor'
password = ''

with open(os.path.expanduser("~/.pgpass")) as pgpass:
    for line in pgpass:
        tokens = line.rstrip().split(':')
        if tokens[3] == user:
            password = tokens[4]
            break

conn = psycopg2.connect('host=localhost port=5432 dbname=postgres ' +
                        'user=%s password=%s ' % (user, password) +
                        'connect_timeout=1')
cur = conn.cursor()

for metric in metrics:
    cur.execute("select * from " +
                "show_activity_stats('%s');" % metric)
    result = cur.fetchone()[0]
    print("%s.%s.%s.%s %d %d" % (gr_prefix, hostname_s, me,
                                 metric, result, current_ts))
