#!/usr/bin/env python

import socket
import time
import sys
import psycopg2
import os

me = sys.argv[0].split('/')[-1].split('.')[0]
hostname = socket.gethostname()
hostname_s = hostname.replace('.', '_')
current_ts = int(time.time())
gr_prefix = "{{ salt['grains.get']('domain', 'mail.yandex.net').split('.')[0].replace('cmail', 'mail') }}.pg"

metrics = ['numbackends', 'xact_commit', 'xact_rollback', 'blks_read',
           'blks_hit', 'tup_returned', 'tup_fetched', 'tup_inserted',
           'tup_updated', 'tup_deleted']

user = 'monitor'
password = ''

with open(os.path.expanduser("~/.pgpass")) as pgpass:
    for line in pgpass:
        tokens = line.rstrip().split(':')
        if tokens[3] == user:
            password = tokens[4]
            break

conn = psycopg2.connect('host=localhost port=5432 dbname=postgres ' +
                        'user=%s password=%s ' % (user, password) +
                        'connect_timeout=1')
cur = conn.cursor()

res = cur.execute("show transaction_read_only")
tr_readonly = cur.fetchone()
if tr_readonly[0] == "off":
    is_master = "master"
    print("%s.%s.%s.is_master %d %d" % (gr_prefix, hostname_s,
                                        me, 1, current_ts))

    cur.execute("select datname, pg_database_size(datname) from pg_catalog.pg_database \
            where datname not in ('template0', 'template1', 'postgres');")
    for result in cur.fetchall():
        print("%s.%s.%s.db.%s.size %d %d" % (gr_prefix, hostname_s, me,
                                             result[0].replace('.', '_'),
                                             result[1], current_ts))
else:
    is_master = "replica"
    print("%s.%s.%s.is_master %d %d" % (gr_prefix, hostname_s, me,
                                        0, current_ts))

for metric in metrics:
    cur.execute("SELECT sum(%s) FROM pg_stat_database;" % metric)
    result = cur.fetchone()[0]
    print("%s.%s.%s.%s_%s %d %d" % (gr_prefix, hostname_s, me, is_master,
                                    metric, result, current_ts))
    print("%s.%s.%s.%s %d %d" % (gr_prefix, hostname_s, me, metric,
                                 result, current_ts))
