#!/usr/bin/env python

import socket
import time
import sys
import psycopg2
import os

me = sys.argv[0].split('/')[-1].split('.')[0]
hostname = socket.gethostname()
hostname_s = hostname.replace('.', '_')
current_ts = int(time.time())

user = 'monitor'
with open(os.path.expanduser("~/.pgpass")) as pgpass:
    for line in pgpass:
        tokens = line.rstrip().split(':')
        if tokens[3] == user:
            password = tokens[4]
            break

queries = {'rpopdb': [
           ('rpop_info', '% from rpop.pop_profile pp where exists (select ? ' +
                         'from rpop_service where pp.chunk_id = chunk_id ' +
                         'and owner=$1::text) and is_on <> ? and uname>?%'),
           ('rpop_list', '%from rpop.pop_profile pp where is_on <> ? and ' +
                         'uname>? and exists (select ? from ' +
                         'rpop.rpop_service where pp.chunk_id = chunk_id ' +
                         'and owner=$1::text)%'),
           ('api_list', 'select p.popid, server, port, login, password, ' +
                        'use_ssl, email, is_on, last_connect, ' +
                        'session_duration, bad_retries, error_status, ' +
                        'last_msg_count, delete_msg, abook_sync_state, ' +
                        'date_part(?, date_unread - timestamp ?) as ' +
                        'unread_delta, ? as action_id, use_imap, ' +
                        'imap_root_folder from pop_profile p where ' +
                        'p.uname = $1::int8 order by p.create_date, p.popid'),
           ('rpop_update', '%rpop.rpop_update%'),
           ('imap_uidl_list', 'select uidl from rpop.rpop_imap_uidls ' +
                              'where folder_id=$1::int8'),
           ('append_imap_uidl', '%rpop.append_imap_uidl%'),
           ('append_imap_folder', '%append_imap_folder%'),
           ('append_uidl', '%rpop.append_uidl%'),
           ('api_create', 'insert into rpop.pop_profile(' +
                          'server,port,login,password%'),
           ('api_delete', 'delete from rpop.pop_profile where ' +
                          'uname=i_uname and popid=i_popid'),
           ('api_update', 'update rpop.pop_profile set server=i_server, ' +
                          'port=i_port, login=i_login, ' +
                          'password=i_password, use_ssl=i_use_ssl%'),
           ('gethungchunk', '%and last_connect < current_timestamp ' +
                            '- delay * interval%'),
           ('getbusychunk', '%rpop.getbusychunk%'),
           ('save_imap_folders', '%save_imap_folders%'),
           ('delete_imap_folder', '%delete_imap_folder%'),
           ('updaterequester', '%updaterequester%'),
           ('chunk_release', '%chunk_release%'),
           ('findoldchunk', '%findoldchunk%'),
           ('chunks_update', '%chunks_update%'),
           ('uidl_list', '%select uidl from rpop.rpop_uidl%'),
           ('get_chunks', '%get_chunks%'),
           ('can_add_task', '%can_add_task%'),
           ('get_chunk', '%get_chunk%'),
           ('remove_mids_from_chunks', '%remove_mids_from_chunks%'),
           ('remove_chunk', '%remove_chunk%'),
           ('add_task', '%add_task%')],
           'maildb': [
	   ('store_message', '%code.store_message(%')],
	   'mopsdb': [
           ('get_chunks', '%get_chunks(%'),
           ('can_add_task', '%can_add_task(%'),
           ('get_chunk', '%get_chunk(%'),
           ('remove_mids_from_chunks', '%remove_mids_from_chunks(%'),
           ('remove_chunk', '%remove_chunk(%'),
           ('add_task', '%add_task(%'),
           ('choose_chunk_ids', '%choose_chunk_ids(%'),
           ('user_stat', '%user_stat(%'),
           ('get_task', '%get_task(%'),
           ('get_chunks_by_mids', '%get_chunks_by_mids(%'),
           ('choose_users', '%choose_users(%'),
           ('has_tasks', '%has_tasks(%')]}

conn = psycopg2.connect('host=localhost port=5432 dbname=postgres ' +
                        'user=%s password=%s ' % (user, password) +
                        'connect_timeout=1')
cur = conn.cursor()

cur.execute('select datname from pg_database;')
result = cur.fetchall()
dbnames = list(map(lambda x: x[0], result))

for dbname in queries:
    if dbname not in dbnames:
        continue
    cur.execute("select 1 from pg_views where " +
                "viewname = 'pg_stat_statements';")
    result = cur.fetchall()
    if len(result) != 1:
        continue
    for query in queries[dbname]:
        try:
            cur.execute("with stats as (select query, calls, " +
                        "shared_blks_read, " +
                        "shared_blks_hit from monitor_stat_statements " +
                        "inner join pg_database on pg_database.oid = " +
                        "monitor_stat_statements.dbid where " +
                        "pg_database.datname = '%s') " % dbname +
                        "select sum(calls), sum(shared_blks_read), " +
                        "sum(shared_blks_hit) from stats " +
                        "where query like '%s';" % query[1])
            result = cur.fetchone()
            print("%s.%s.%s.%s.%s.%s %d %d" % ('mail.pg', hostname_s, me,
                                               dbname, query[0], 'calls',
                                               result[0], current_ts))
            print("%s.%s.%s.%s.%s.%s %d %d" % ('mail.pg', hostname_s, me,
                                               dbname, query[0], 'read',
                                               result[1], current_ts))
            print("%s.%s.%s.%s.%s.%s %d %d" % ('mail.pg', hostname_s, me,
                                               dbname, query[0], 'hit',
                                               result[2], current_ts))
        except Exception:
            cur = conn.cursor()
            pass
