#!/usr/bin/env python

import socket
import time
import sys
import psycopg2
import os

me = sys.argv[0].split('/')[-1].split('.')[0]
hostname = socket.gethostname()
hostname_s = hostname.replace('.', '_')
current_ts = int(time.time())
gr_prefix = "mail.pg"

user = 'monitor'
password = ''

with open(os.path.expanduser("~/.pgpass")) as pgpass:
    for line in pgpass:
        tokens = line.rstrip().split(':')
        if tokens[3] == user:
            password = tokens[4]
            break

conn = psycopg2.connect('host=localhost port=5432 dbname=postgres ' +
                        'user=%s password=%s ' % (user, password) +
                        'connect_timeout=1')
cur = conn.cursor()

cur.execute("SELECT extname FROM pg_catalog.pg_extension;")
res = [i[0] for i in cur.fetchall()]
if res and 'pg_stat_wait' not in res:
    sys.exit(0)

cur.execute("SELECT event_name, sum(wait_time) AS wait_time, "
    "sum(wait_count) AS wait_count FROM pg_stat_wait_profile "
    "WHERE class_id = 1 AND wait_time != 0 AND wait_count != 0 "
    "GROUP BY event_name ORDER BY wait_time DESC;")
for res in cur.fetchall():
    print("%s.%s.%s.times.%s %d %d" % (gr_prefix, hostname_s, me,
                                 res[0], res[1], current_ts))
#    print("%s.%s.%s.count.%s %d %d" % (gr_prefix, hostname_s, me,
#                                 res[0], res[2], current_ts))

