graphite-packages:
    pkg.installed:
        - pkgs:
            - yandex-graphite-checks-system: 1.0-15
            - yabs-graphite-sender: 0.2.30
            - yabs-graphite-client: 0.2.30
            - yabs-graphite-sender-config-ng: 0.2-2

yandex-graphite-checks-system-conf:
    file.managed:
        - name: /etc/graphite-checks.conf
        - source: salt://components/graphite/settings/yandex-graphite-checks-system.conf
        - template: jinja
        - watch:
            - pkg: graphite-packages

graphite-scripts-dir:
    file.directory:
        - name: /usr/share/graphite-client
        - makedirs: True
        - watch:
            - pkg: graphite-packages

graphite-scripts:
    file.recurse:
        - name: /usr/share/graphite-client/
        - file_mode: '0755'
        - source: salt://{{ slspath }}/scripts
        - include_empty: True
        - watch:
            - pkg: graphite-packages
            - file: graphite-scripts-dir

