#!/usr/bin/python

import subprocess, socket, urllib, time, sys

me = sys.argv[0].split('/')[-1].split('.')[0]
hostname = socket.gethostname()
hostname_s = hostname.replace('.', '_')
#cgroup = urllib.urlopen("http://c.yandex-team.ru/api/hosts2groups/%s" % hostname).read().rstrip()
__ = open('/etc/conductor_group', 'r')
cgroup = __.read().strip()
__.close()
current_ts = int(time.time())

cmd = 'timetail -n60 -t yplatform /var/log/ymsettings/access.log'
p = subprocess.Popen(cmd.split(), stdout=subprocess.PIPE, stderr=open('/dev/null'))
all_records = p.communicate()[0].splitlines()

codes = [int(record.split()[7]) for record in all_records]

res = {}
res['200'] = len([item for item in codes if item == 200])
res['30x'] = len([item for item in codes if 300 <= item < 400])
res['40x'] = len([item for item in codes if 400 < item <= 500])
res['50x'] = len([item for item in codes if item >= 500])

for k,v in res.items():
	print("%s.%s.%s.%s %d %d" % (cgroup, hostname_s, me, k, v, current_ts))
