#!/usr/bin/python

import subprocess, socket, urllib, time, sys

me = sys.argv[0].split('/')[-1].split('.')[0]
hostname = socket.gethostname()
hostname_s = hostname.replace('.', '_')
#cgroup = urllib.urlopen("http://c.yandex-team.ru/api/hosts2groups/%s" % hostname).read().rstrip()
__ = open('/etc/conductor_group', 'r')
cgroup = __.read().strip()
__.close()
current_ts = int(time.time())

cmd = 'pa -S oracle -t60 /var/log/profiler.log'
p = subprocess.Popen(cmd.split(), stdout=subprocess.PIPE, stderr=open('/dev/null'))
all_records = p.communicate()[0].splitlines()

timings = [float(record.split()[-1]) for record in all_records]

res = {}
res['20ms'] = len([item for item in timings if item <= 0.02])
res['100ms'] = len([item for item in timings if 0.02 < item <= 0.1])
res['300ms'] = len([item for item in timings if 0.1 < item <= 0.3])
res['1s'] = len([item for item in timings if 0.3 < item <= 1])
res['over1s'] = len([item for item in timings if item > 1])

for k,v in res.items():
	print("%s.%s.%s.%s %d %d" % (cgroup, hostname_s, me, k, v, current_ts))
