#!/usr/bin/python

import sys, time, subprocess, socket

me = sys.argv[0].split('/')[-1].split('.')[0]
current_ts = int(time.time())
hostname_s = socket.gethostname().replace('.', '_')
log = '/var/log/ymsettings/ymsettings.log'
cmd = '/home/monitor/agents/bin/tailme %s %s | fgrep error' % (me, log)

p = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE)
errors = p.communicate()[0].splitlines()

exceptions=(
	'Operation canceled', 
	'handle_connect: error:', 
	'deadline request/execute error', 
	'.mail.yandex.net:1580/invalidate_cache',
	'blackbox',
	'ORA-',
	'no free workers',
	'User profile not found'
	)

d = {}
d['bb_errors'] = len([line for line in errors if 'blackbox' in line])
d['oracle_errors'] = len([line for line in errors if 'ORA-' in line])
d['no_free_workers'] = len([line for line in errors if 'no free workers' in line])
d['user_profile_not_found']  = len([line for line in errors if 'User profile not found' in line])
d['other_errors']  = len([line for line in errors if not any([i for i in exceptions if i in line])])

for k,v in d.items():
	print("mail.mail_settings.%s.%s.%s %d %d" % (hostname_s, me, k, v, current_ts))

