#!/bin/sh
hostname=`sed -e 's/\./_/g' <<< $(hostname -f)`
preamble="mail_settings.${hostname}.yplatform"
/bin/ps axo nlwp=Threads,pmem=PercentMem,vsz=VirtualSize,rsz=ActualSize,command | awk -v preamble=${preamble} -v now=`date +%s` '/\/usr\/sbin\/[y]platform/ {
	printf("%s.%s %s %i\n", preamble, "threadsnum", $1, now);
	printf("%s.%s %s %i\n", preamble, "mempercent", $2, now );
	printf("%s.%s %s %i\n", preamble, "vsize", $3, now);
	printf("%s.%s %s %i\n", preamble, "rsize", $4, now);
}'
