#!/bin/bash
log="/var/log/sharpei/status.log"
ts=`date +%s`
host=`hostname -f | tr '.' '_'`
status="mail.mail_sharpei.${host}.shard_flaps"

# $0 = [2016-Feb-18 19:48:17.084639] status=info session=GmcBXmt4R4Y1 request=poller_worker shard=2076 host=xdb19d.mail.yandex.net role=replica smooth_state=dead states=[dead, dead, dead]
# $6 = shard=2076
timetail -n 60 -t mulcagate ${log} |\
    awk -v status=${status} -v ts=${ts} \
    '/smooth_state=dead/ \
    { gsub(/[^0-9. ]/,"",$6); stat[int($6)]++; } \
	END {for (key in stat){ printf "%s.%s %i %i\n", status, key, stat[key], ts}}'
