{% if salt['grains.get']('virtual', 'physical') == 'physical' %}
hw-watcher-pkg:
    pkg.installed:
{% if salt['grains.get']('osfullname') == 'Ubuntu' %}
        - pkgs:
            - yandex-hw-watcher: 0.6.7.4
            - yandex-hw-watcher-shelf-tool-plugin: 1.0
            - mcelog: 157+dfsg-1yandex1
        - require:
            - pkgrepo: common-stable-all
{% else %}
        - pkgs:
            - yandex-hw-watcher: 0.5.3.4-1
            - yandex-hw-watcher-shelf-tool-plugin: 1.1-1
{% endif %}

/etc/hw_watcher/hw_watcher.conf:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath + '/conf/hw_watcher.conf' }}
        - require:
            - pkg: hw-watcher-pkg
{% endif %}

include:
    - components.monrun2.hw-watcher
