{% from "components/mdb-metrics/map.jinja" import mdb_metrics with context %}

{% set mdb_metrics_path = 'components/mdb-metrics' %}
{% macro deploy_configs(conf_type, conf_dir=mdb_metrics_path) %}

{% set configs = mdb_metrics['configs'][conf_type] %}
{% for conf in configs %}
mdb-metrics-{{ conf }}-config:
    file.managed:
        - name: /etc/mdb-metrics/conf.d/available/{{ conf }}.conf
        - template: jinja
        - source: salt://{{ conf_dir }}/conf/{{ conf_type }}/{{ conf }}.conf
        - watch_in:
            - service: mdb-metrics-service
{% if conf_type in ('pg_unmanaged',) %}
        - defaults:
            databases: {{ mdb_metrics['unmanaged_databases'] }}
{% elif conf_type in ('pg_maildb',) %}
        - defaults:
            databases: ['maildb']
{% endif %}
mdb-metrics-{{ conf }}-link:
    file.symlink:
        - name: /etc/mdb-metrics/conf.d/enabled/{{ conf }}.conf
        - target: /etc/mdb-metrics/conf.d/available/{{ conf }}.conf
        - watch_in:
            - service: mdb-metrics-service
{% endfor %}
{% endmacro %}
