{% from "components/mdb-metrics/map.jinja" import mdb_metrics with context %}
{% set osrelease = salt['grains.get']('osrelease') %}

mdb-metrics-pkg:
    pkg.installed:
        - pkgs:
            - yandex-mdb-metrics: {{ mdb_metrics['version'] }}
{% if osrelease == '14.04' %}
            - libpython3.6: 3.6.6-2yandex19
            - libpython3.6-minimal: 3.6.6-2yandex19
            - libpython3.6-stdlib: 3.6.6-2yandex19
            - python3.6: 3.6.6-2yandex19
            - python3.6-minimal: 3.6.6-2yandex19
            - python3.6-venv: 3.6.6-2yandex19
            - libmpdec2: 2.4.2-2yandex2
{% elif osrelease == '18.04' %}
            - libpython3.6
            - libpython3.6-minimal
            - libpython3.6-stdlib
            - python3.6
            - python3.6-minimal
            - python3.6-venv
            - libmpdec2
            - python3-distutils-extra
{% endif %}
        - require_in:
            - service: mdb-metrics-service

/etc/mdb-metrics/conf.d/available:
    file.directory:
        - user: root
        - group: root
        - makedirs: True
        - mode: 755

/etc/mdb-metrics/conf.d/enabled:
    file.directory:
        - user: root
        - group: root
        - makedirs: True
        - mode: 755
        - require_in:
            - service: mdb-metrics-service

mdb-metrics-config:
    file.managed:
        - name: /etc/mdb-metrics/mdb-metrics.conf
        - template: jinja
        - source: salt://{{ slspath }}/conf/mdb-metrics.conf
        - defaults:
{% if salt['pillar.get']('yandex:environment', 'dev') == 'prod' %}
            environment: production
{% else %}
            environment: testing
{% endif %}
            yasm_tags_cmd: {{ mdb_metrics['main']['yasm_tags_cmd'] }}
        - require_in:
            - service: mdb-metrics-service

mdb-metrics-plugins:
    file.recurse:
        - name: /etc/mdb-metrics/plugins
        - file_mode: '0644'
        - template: jinja
        - source: salt://{{ slspath }}/conf/plugins
        - include_empty: True
        - watch_in:
            - service: mdb-metrics-service
        - require_in:
            - service: mdb-metrics-service

{% if salt['pillar.get']('data:cluster_private_key') %}
cluster-key:
    file.managed:
        - name: /etc/mdb-metrics/cluster_key.pem
        - file_mode: '0640'
        - template: jinja
        - contents_pillar: data:cluster_private_key
        - watch_in:
            - service: mdb-metrics-service
{% endif %}

mdb-metrics-service:
    service:
        - running
        - enable: true
        - name: mdb-metrics
        - watch:
            - pkg: mdb-metrics-pkg
            - file: mdb-metrics-plugins
            - file: mdb-metrics-config
{% if salt['pillar.get']('data:use_yasmagent', True) %}
        - require:
            - file: yasmagent-instance-getter
{% endif %}

/etc/cron.d/wd-mdb-metrics:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/wd-mdb-metrics

include:
{% if salt['pillar.get']('data:mdb_metrics:sys_common', True) %}
    - .sys_common
{% endif %}
{% if salt['pillar.get']('data:dbaas:vtype', 'porto') == 'compute' %}
    - .compute
{% endif %}
