{% from "components/mdb-metrics/map.jinja" import mdb_metrics with context %}
{% set common_configs = mdb_metrics['configs']['sys_common'] %}
{% for conf in common_configs %}
mdb-metrics-{{ conf }}-config:
    file.managed:
        - name: /etc/mdb-metrics/conf.d/available/{{ conf }}.conf
        - template: jinja
        - source: salt://{{ slspath }}/conf/sys_common/{{ conf }}.conf
        - watch_in:
            - service: mdb-metrics-service
        - require:
            - file: /etc/mdb-metrics/conf.d/available
mdb-metrics-{{ conf }}-link:
    file.symlink:
        - name: /etc/mdb-metrics/conf.d/enabled/{{ conf }}.conf
        - target: /etc/mdb-metrics/conf.d/available/{{ conf }}.conf
        - watch_in:
            - service: mdb-metrics-service
        - require:
            - file: /etc/mdb-metrics/conf.d/enabled
{% endfor %}
