include:
    - components.mongodb30

{% set shard = salt['grains.get']('id').split('.')[0][-2:][:-1] %}
/u0:
    mount.mounted:
        - device: '/dev/md2'
        - fstype: ext4
        - mkmnt: True
        - opts:
            - defaults

/u0/mongodb/doc{{shard}}:
    file.directory:
        - user: mongodb
        - group: mongodb
        - mode: 755
        - makedirs: True
        - require_pre:
            - components.mongodb30
        - require:
            - mount: /u0

/etc/mongodb.conf:
    file.managed:
        - template: jinja
        - source: salt://components/mongodb-dbs/docdb/conf/doc{{shard}}/mongodb.conf
        - mode: 644

/etc/default/mongodb:
    file.managed:
        - template: jinja
        - source: salt://components/mongodb-dbs/docdb/conf/mongodb-default
        - mode: 644
