{% from slspath ~ "/map.jinja" import mongodb with context %}
{% set host = salt['grains.get']('fqdn') %}

{% if mongodb.cluster_auth == 'keyfile' %}
{{mongodb.config_prefix}}/mongodb.key:
    file.managed:
        - template: jinja
        - source: salt://{{slspath}}/conf/templates/mongodb.key
        - user: {{mongodb.user}}
        - group: {{mongodb.user}}
        - mode: 400
        - require:
            - file: {{mongodb.config_prefix}}
        - require_in:
            - service: mongod-service
{% endif %}

{% set admin = salt['pillar.get']('data:mongodb:users:admin') %}
{% for srv in mongodb.services_deployed %}
{% set config = mongodb.config.get(srv) %}
add-admin-user-{{srv}}:
    mongodb.user_create:
        - name: admin
        - passwd: "{{admin.password}}"
        - roles: ['root']
        - authdb: admin
        - host: localhost
        - port: {{mongodb.config[srv].net.port}}
        - unless:
            - "/usr/bin/mongo --quiet --norc --port {{config.net.port}} --username admin --password {{admin.password}} admin --eval 'quit()'"
        - require:
            - mongodb: {{srv}}-service            
{% if srv in ('mongod', 'mongocfg',) %}
            - mongodb: replicaset-member
{% endif %}
{% endfor %}


{% for name, props in salt['pillar.get']('data:mongodb:users').items() %}
{% for srv in mongodb.services_deployed %}
{% if srv in props['services'] %}
{% for db, roles in props['dbs'].items() %}
add-{{name}}-{{srv}}-{{db}}:
    mongodb.user_present:
        - name: {{name}}
        - passwd: {{props.get('password', name)|yaml_encode}}
        - database: {{db}}
        - host: {{host}}
        - port: {{mongodb.config[srv].net.port}}
        - user: admin
        - password: "{{admin.get('password', 'admin')}}"
        - require:
            - mongodb: add-admin-user-{{srv}}
            - mongodb: {{srv}}-service
{% endfor %}
{% endif %}
{% endfor %}
{% endfor %}


{% for name, props in salt['pillar.get']('data:mongodb:users').items() %}
{% for srv in mongodb.services_deployed %}
{% if srv in props['services'] %}
{% for db, roles in props['dbs'].items() %}
roles-{{name}}-{{srv}}-{{db}}:
    mongodb.user_set_roles:
        - name: {{name}}
        - database: {{db}}
        - roles: {{roles}}
        - host: {{host}}
        - port: {{mongodb.config[srv].net.port}}
        - user: admin
        - password: "{{admin.get('password', 'admin')}}"
        - require:
            - mongodb: add-{{name}}-{{srv}}-{{db}}
            - mongodb: {{srv}}-service
{% endfor %}
{% endif %}
{% endfor %}
{% endfor %}


{% for name, props in salt['pillar.get']('mongodb_revoke_dbs', {}).items() %}
{% for srv in mongodb.services_deployed %}
{% if srv in props.get('services', ['mongod', 'mongos']) %}
{% for db in props['dbs'].keys() %}
del-{{name}}-{{srv}}-{{db}}:
    mongodb.user_absent:
        - name: {{name}}
        - host: {{host}}
        - database: {{db}}
        - port: {{mongodb.config[srv].net.port}}
        - user: admin
        - password: "{{admin['password']}}"
        - require:
            - mongodb: add-admin-user-{{srv}}
            - service: {{srv}}-service
{% endfor %}
{% endif %}
{% endfor %}
{% endfor %}

/root/.mongopass:
    file.managed:
        - template: jinja
        - source: salt://{{slspath}}/conf/mongopass
        - user: root
        - group: root
        - makedirs: True
        - mode: 400 
