/etc/logrotate.d/mongodb:
    file.managed:
        - source: salt://{{ slspath }}/conf/mongodb.logrotate
        - mode: 644 

/root/.bashrc:
    file.managed:
        - source: salt://{{ slspath }}/conf/bashrc_root
        - template: jinja
        - user: root
        - group: root
        - mode: 644
        - unless:
            - grep 'alias mongo' /root/.bashrc

/root/.mongorc.js:
    file.managed:
        - source: salt://{{ slspath }}/conf/mongorc.js
        - user: root
        - group: root
        - mode: 640

{% if salt['grains.get']('virtual') == 'lxc'%}
/etc/cron.d/mongo_porto_chown:
    file.managed:
        - contents: |
             PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin
             @reboot root chown mongodb.mongodb /var/lib/mongodb >/dev/null 2>&1
        - mode: 644
{% endif %}
