__ansi = {
    csi: String.fromCharCode(0x1B) + '[',
    reset:      '0',
    text_prop:  'm',
    foreground: '3',
    bright:     '1',
    underline:  '4',

    colors: {
        black:   '0',
        red:     '1',
        green:   '2',
        yellow:  '3',
        blue:    '4',
        magenta: '5',
        cyan:    '6',
        gray:    '7',
    }
};

function controlCode( parameters ) {
    if ( parameters === undefined ) {
        parameters = "";
    }
    else if (typeof(parameters) == 'object' && (parameters instanceof Array)) {
        parameters = parameters.join(';');
    }

    return __ansi.csi + String(parameters) + String(__ansi.text_prop);
};

function applyColorCode( string, properties, nocolor ) {
    return controlCode(properties) + String(string) + controlCode()
};

function colorize( string, color, nocolor ) {

    var params = [];
    var code = __ansi.foreground + __ansi.colors[color.color];

    params.push(code);

    if ( color.bright === true ) params.push(__ansi.bright);
    if ( color.underline === true ) params.push(__ansi.underline);

    return applyColorCode( string, params, nocolor );
};

auth_connect = function(db, username) {
    var cur_db = db.getMongo() + '';
    var port = cur_db.trim().split(":").slice(-1)[0];
    var lines = cat("/root/.mongopass").split("\n")
    for (lnum = 0; lnum < lines.length; lnum++){
        fields = lines[lnum].split(":");
        if (fields[3] == username && fields[1] == port) break;
    }

    if (lnum >= lines.length) {
        print("ERROR: Admin credentials for port " + port + " and db admin were not found")
        quit()
    }

    var url = fields[0] + ":" + fields[1] + "/" + fields[2]
    var db = connect(url, fields[3], fields[4]);
    return db
}

getPrimaryOptimeDate = function() {
  var members = rs.status().members;
  for(var i=0; i < members.length; i++) {
    var member = members[i];
    if(member['stateStr'] == 'PRIMARY') {
      return member['optimeDate'];
    }
  }
}

getMyOptimeDate = function() {
  var members = rs.status().members;
  for(var i=0; i < members.length; i++) {
    var member = members[i];
    if(member['self']) {
      return member['optimeDate'];
    }
  }
}

getReplicationLag = function() {
  var members = rs.status().members;
  if(!members) {
    return null;
  }
  return ((getPrimaryOptimeDate() - getMyOptimeDate()) / 1000);
}

summary = function() {
  var uptime = db_server_status.uptime;
  var setName = db_server_status.repl.setName;
  var primary = db_server_status.repl.primary;
  var replag = getReplicationLag();
  var curConnections = db_server_status.connections.current;
  var resMem = db_server_status.mem.resident;
  var userAsserts = db_server_status.asserts.user;
  var warningAsserts = db_server_status.asserts.warning;
  var totalQueues = db_server_status.globalLock.currentQueue.total;
  var lockRatio = db_server_status.globalLock.ratio;
  var readQueues = db_server_status.globalLock.currentQueue.readers;
  
  print('\tSystem information as of ' + db_server_status.localTime)
  print('\n\t** Replication **');
  print("\tPrimary: " + primary + "\tReplag: " + replag + ' (s)');

  print('\n\t** Uptime **');
  var uptimeHours = Math.floor(uptime / (60 * 60));
  var uptimeMinutes = Math.floor((uptime - (uptimeHours * 60 * 60)) / 60);
  print("\tuptime: " + uptime + ' (s)' + '\thuman: ' + uptimeHours + 'h' + ' and ' + uptimeMinutes + 'm');

  print('\n\t** Connections **');
  print("\tCurrent: " + curConnections + "\tQueued: " + totalQueues + "\t% read:" + readQueues / (totalQueues + 1) + "\tLock Ratio: " + lockRatio);

  print('\n\t** Asserts **');
  print("\tUser: " + userAsserts + "\tWarning: " + warningAsserts);
}

prompt = function() {
  var state = '';
  var stateInfo = db.getSiblingDB('admin').runCommand({replSetGetStatus: 1, forShell: 1});
  if (stateInfo.ok) {
  // Report the self member's stateStr if it's present.
    stateInfo.members.forEach(function(member) {
      if (member.self) {
        state = member.stateStr;
      }
    });
    // Otherwise fall back to reporting the numeric myState field (mongodb 1.6).
    if (!state) {
      state = stateInfo.myState;
    }

    state = '' + stateInfo.set + ':' + host + ':' + state;
    } else {
        var info = stateInfo.info;
        if (info && info.length < 20) {
            state = info;  // "mongos", "configsvr"
        } else {
            throw _getErrorWithCode(stateInfo, "Failed:" + info);
        }
    }
    return state + '> ';


  return host + '/' + db + " " + state + ' # ';
}

var db = auth_connect(db, "admin")
var db_server_status = db.serverStatus();
host = db_server_status.host.split('.')[0]


