#!/usr/bin/python

import sys
import json
import socket
import os
import pymongo

ITYPE = 'disk'
CONDUCTOR_GRAINS_FILE = '/tmp/.grains_conductor.cache'
PASSFILE = '~/.mongopass'
DBAAS_FILE = '/etc/dbaas.conf'

MONGO_ELECTION_TIMEOUT = 1000

MONGO_DEFAULT_HOST = socket.getfqdn()
MONGO_DEFAULT_PORT = 27018
MONGO_DEFAULT_DBNAME = 'admin'
MONGO_DEFAULT_TIER = 'secondary'


def get_conductor_data():
    with open(CONDUCTOR_GRAINS_FILE) as cg_fobj:
        conductor = json.loads(cg_fobj.read())

    if os.path.exists(DBAAS_FILE):
        with open(DBAAS_FILE) as dbaas_fobj:
            dbaas = json.loads(dbaas_fobj.read())
        ctype = dbaas.get('cluster_id', 'none')
    else:
        ctype = conductor.get('group', '').replace('_', '-')

    datacenter = conductor.get('short_dc', 'nodc')
    if not datacenter:
        datacenter = conductor.get('switch')[:3]

    return ctype, datacenter


def get_tier(host=None, port=None, dbname=None):
    if host is None:
        host = MONGO_DEFAULT_HOST
    if port is None:
        port = MONGO_DEFAULT_PORT
    if dbname is None:
        dbname = MONGO_DEFAULT_DBNAME

    connect_uri = 'mongodb://{host}:{port}/{dbname}'.format(
        host=host, port=port, dbname=dbname)

    conn = pymongo.MongoClient(
        connect_uri, serverSelectionTimeoutMS=MONGO_ELECTION_TIMEOUT)

    result = 'primary'\
        if conn[dbname].command('ismaster')['ismaster'] else 'secondary'

    conn.close()
    return result


def main():
    try:
        tier = get_tier()
    except Exception:
        tier = MONGO_DEFAULT_TIER

    try:
        ctype, datacenter = get_conductor_data()
    except Exception:
        sys.exit(1)

    host = "{{ salt['grains.get']('id') }}"
    prj = host.split('.')[0][:-1]
    res = MONGO_DEFAULT_HOST + ':11003@' + ITYPE + \
        ' a_itype_' + ITYPE + \
        ' a_prj_' + prj + \
        ' a_ctype_' + ctype + ' a_geo_' + datacenter + \
        ' a_tier_' + tier

    print(res)


if __name__ == '__main__':
    main()

