{% from slspath ~ "/map.jinja" import mongodb with context %}

mongodb-configsrv-packages:
    pkg.installed:
        - order: 1
        - pkgs:
            - mongodb-org-server: {{ mongodb.version.pkg }}
            - mongodb-org-shell: {{ mongodb.version.pkg }}
            - numactl: '2.0.9~rc5-1ubuntu3.14.04.2'

/etc/init/mongodb-config.conf:
    file.managed:
        - template: jinja
        - source: salt://{{slspath}}/conf/init/mongodb-config.conf
        - mode: 644
        - require:
            - pkg: mongodb-configsrv-packages

mongodb-configsrv-service:
  service.running:
    - enable: True
    - name: mongodb-config
    - watch:
      - pkg: mongodb-configsrv-packages
      - file: /etc/init/mongodb-config.conf
      - file: {{mongodb.config_prefix}}/mongodb-config.conf
{% if mongodb.use_auth %}
      - file: {{mongodb.config_prefix}}/mongodb.key
{% endif %}
    - require:
      - file: /etc/init/mongodb-config.conf
      - file: {{mongodb.config_prefix}}/mongodb-config.conf
      - file: {{mongodb.db_prefix}}/configdb

{{mongodb.config_prefix}}/mongodb-config.conf:
    file.managed:
        - template: jinja
        - source: salt://{{slspath}}/conf/templates/config.conf
        - mode: 644
        - makedirs: True
        - require:
            - pkg: mongodb-configsrv-packages

{{mongodb.db_prefix}}/configdb:
    file.directory:
        - user: {{mongodb.user}}
        - group: {{mongodb.user}}
        - mode: 775
        - require:
            - pkg: mongodb-configsrv-packages
