{% from slspath ~ "/map.jinja" import mongodb with context %}


{% for srv in mongodb.services_deployed %}
{% set config = mongodb.config.get(srv) %}
{{mongodb.config_prefix}}:
    file.directory:
        - user: root
        - group: root
        - mode: 755
        - makedirs: True

{{config.storage.dbPath}}:
    file.directory:
        - user: {{mongodb.user}}
        - group: {{mongodb.user}}
        - mode: 755
        - makedirs: True
        - name: {{config.storage.dbPath}}

{{mongodb.homedir}}:
    file.directory:
        - user: {{mongodb.user}}
        - group: {{mongodb.user}}
        - mode: 700
    require:
        - pkg: {{srv}}-packages

/var/log/mongodb:
    file.directory:
        - user: root
        - group: {{mongodb.user}}
        - mode: 775
{% endfor %}
