{% from slspath ~ "/map.jinja" import mongodb, mdb_metrics with context %}

include:
    - .directories
    - components.monrun2.mongodb
{% if mongodb.use_mongod %}
    - .mongod
    - .limits
    - .sysctl
    - .groups
{% endif %}
{% if mongodb.use_auth  %}
    - .ssl
    - .auth
{% endif %}
{% if mongodb.use_mongos %}
    - .mongos
{% endif %}
{% if salt['grains.get']('fqdn') in salt['pillar.get']('data:mongodb:config_servers', []) %}
    - .mongocfg
{% endif %}
{% if mongodb.use_wd_mongodb %}
    - .wd-service
{% endif %}
{% if mdb_metrics.enabled %}
    - .mdb-metrics
{% endif %}
    - .yasmagent
    - .common
{% if salt['pillar.get']('data:genbackup:enabled', False) %}
    - components.genbackup
{% endif %}
{% if salt['pillar.get']('data:ship_logs', False) %}
    - components.pushclient
    - .pushclient
{% endif %}
{% if salt['pillar.get']('service-restart', False) %}
    - .restart
{% endif %}
