{% from slspath ~ "/map.jinja" import mongodb with context %}
{% set config = mongodb.config.get('mongod') %}
{% set host = salt['grains.get']('fqdn') %}

mongod-packages:
    pkg.installed:
        - order: 1
        - pkgs:
            - mongodb-org-server: {{ mongodb.version.pkg }}
            - mongodb-org-shell: {{ mongodb.version.pkg }}
            - mongodb-org-tools: {{ mongodb.version.pkg }}
            - numactl: '2.0.9~rc5-1ubuntu3.14.04.2'
            - python-pymongo: '3.1.1-yandex1'
            - python-bson: '3.1.1-yandex1'

/etc/init/mongodb.conf:
    file.managed:
        - template: jinja
        - require:
            - pkg: mongod-packages
        - source: salt://{{ slspath }}/conf/init/mongodb.conf
        - mode: 644

shutdown-mongod-org:
    cmd.run:
        - name: 'mongo --port 27017 --eval "db.shutdownServer()" admin'
        - require:
            - pkg: mongod-packages
        - unless:
            - "stat /etc/init/mongod.conf.disabled"

disable-mongod-org:
    cmd.run:
        - name: 'mv /etc/init/mongod.conf /etc/init/mongod.conf.disabled'
        - unless:
            - "stat /etc/init/mongod.conf.disabled"

/var/log/mongodb/mongod.log:
    file.absent

mongod-init:
    cmd.run:
        - name: 'rm -rf {{ config.storage.dbPath }}/* && touch {{ mongodb.initialized_flag }}'
        - require:
            - pkg: mongod-packages
            - cmd: disable-mongod-org
            - cmd: shutdown-mongod-org
            - file: {{ mongodb.homedir }}
        - require_in:
            - file: {{ config.storage.dbPath }}
        - unless:
            - ls {{ mongodb.initialized_flag }} || ls {{ config.storage.dbPath }}/admin

mongod-service:
    service.running:
        - enable: True
        - name: mongodb
        - require:
            - pkg: mongod-packages
            - file: /etc/init/mongodb.conf
            - file: {{mongodb.config_prefix}}/mongodb.conf
            - file: {{config.storage.dbPath}}
            - file: /var/log/mongodb
            - cmd: mongod-init
{% if mongodb.use_auth and mongodb.cluster_auth == 'keyfile' %}
            - file: {{mongodb.config_prefix}}/mongodb.key
{% endif %}
{% if mongodb.use_ssl %}
            - cmd: {{mongodb.config_prefix}}/ssl/certkey.pem
{% endif %}
    mongodb.alive:
        - name: localhost
        - port: {{config.net.port}}
        - tries: 10
        - timeout: 5
        - watch:
            - service: mongod-service

{{mongodb.config_prefix}}/mongodb.conf:
    file.managed:
        - template: jinja
        - source: salt://{{slspath}}/conf/templates/mongod.conf
        - mode: 644
        - makedirs: True
        - require:
            - pkg: mongod-packages

{% set admin = salt['pillar.get']('data:mongodb:users:admin') %}
{% if mongodb.is_replica %}
{%     if not mongodb.master_hostname %}
{%         do mongodb.update({'master_hostname': salt['mongodb.find_master'](
                  hosts='data:dbaas:shard_hosts',
                  user='admin',
                  password=salt['pillar.get']('data:mongodb:users:admin:password'),
                  port=27018,
                  timeout=salt['pillar.get']('mongodb-primary-timeout', 600),
              )}) %}
{%     endif %}
{%     if not mongodb.master_hostname %}
replicaset-member:
    cmd.run:
        - name: /bin/false
        - require:
            - mongodb: mongod-service
        - onlyif:
            # Only fire init if configuration is not initialized yet.
            - test $(mongo --quiet --norc --port {{config.net.port}} --eval "rs.status()['code']") = 94
{%     else %}
replicaset-member:
    mongodb.replset_add:
      - require:
          - mongodb: mongod-service
      - onlyif:
          # Only fire init if configuration is not initialized yet.
          - test $(mongo --quiet --norc --port {{config.net.port}} --eval "rs.status()['code']") = 94
      - name: '{{host}}:{{config.net.port}}'
      - host: {{ mongodb.master_hostname }}
      - port: {{config.net.port}}
      - user: admin
      - password: "{{admin['password']}}"
      - authdb: admin
{%     endif %}
{% else %}
replicaset-member:
    mongodb.replset_initiate:
        - require:
            - mongodb: mongod-service
        - onlyif:
            # Only fire init if configuration is not initialized yet.
            - test $(mongo --quiet --norc --port {{config.net.port}} --eval "rs.status()['code']") = 94
        - name: localhost
        - port: {{config.net.port}}
        - authdb: admin
{% endif %}

{% if salt['pillar.get']('data:dbaas:shard_hosts') %}
{%     for rs_host in salt['mongodb.get_rs_members'](user='admin',
                                                     password=salt['pillar.get']('data:mongodb:users:admin:password'),
                                                     host='localhost',
                                                     port=27018) %}
{%         if rs_host not in salt['pillar.get']('data:dbaas:shard_hosts') %}
remove-rs-member-mongod-{{ rs_host }}:
    mongodb.replset_remove:
        - host: {{host}}
        - port: {{config.net.port}}
        - password: "{{admin['password']}}"
        - user: admin
        - authdb: admin
        - name: {{ rs_host }}:{{ config.net.port }}
        - require:
            - mongodb: mongod-service
{%             if salt['pillar.get']('mongodb_mongod_rs_step_down_removing', False) %}
rs-step-down-mongod-{{ rs_host }}:
    mongodb.rs_step_down:
        - name: {{rs_host}}
        - port: {{config.net.port}}
        - password: "{{admin['password']}}"
        - user: admin
        - authdb: admin
        - require_in:
            - mongodb: remove-rs-member-mongod-{{ rs_host }}
{%             endif %}
{%         endif %}
{%     endfor %}
{% endif %}

