{% from slspath ~ "/map.jinja" import mongodb with context %}

mongos-packages:
    pkg.installed:
        - order: 1
        - pkgs:
            - mongodb-org-mongos: {{ mongodb.version.pkg }}
            - mongodb-org-shell: {{ mongodb.version.pkg }}
            - numactl: '2.0.9~rc5-1ubuntu3.14.04.2'

/etc/init/mongos.conf:
    file.managed:
        - template: jinja
        - source: salt://{{slspath}}/conf/init/mongos.conf
        - mode: 644

mongos-service:
  service.running:
    - enable: True
    - name: mongos
    - watch:
      - pkg: mongos-packages
      - file: /etc/init/mongos.conf
      - file: {{mongodb.config_prefix}}/mongos.conf
    - require:
      - file: /etc/init/mongos.conf
      - file: {{mongodb.config_prefix}}/mongos.conf
      - file: /var/log/mongodb
{# This is temporary hack, here we need to wait while mongos started #}
  cmd.wait:
    - name: true
    - watch:
      - service: mongos-service

{{mongodb.config_prefix}}/mongos.conf:
    file.managed:
        - template: jinja
        - source: salt://{{slspath}}/conf/templates/mongos.conf
        - mode: 644
        - makedirs: True
        - require:
            - pkg: mongos-packages
