{% from "components/mongodb/map.jinja" import mongodb with context %}
/etc/pushclient/mongodb_parser.py:
    file.managed:
        - source: salt://{{ slspath }}/conf/pushclient/mongodb_parser.py
        - template: jinja
        - mode: 755
        - makedirs: True
        - require:
            - pkg: pushclient

statbox-in-mongodb-group:
    group.present:
        - name: mongodb
        - addusers:
            - statbox
        - system: True
        - require:
            - user: statbox-user

push-client-mongodb-config:
    file.accumulated:
        - name: push-client-files
        - filename: /etc/pushclient/push-client.conf
        - text: |-
{% for srv in mongodb.services_deployed %}
{%   set config = mongodb.config.get(srv) %}
            - log_type: dbaas-int-log
              name: {{ config.systemLog.path }}
              pipe: /etc/pushclient/mongodb_parser.py -c {{ mongodb.cluster_id }} -o {{ srv }}
{% endfor %}
        - require:
            - file: /etc/pushclient/mongodb_parser.py
        - require_in:
            - file: /etc/pushclient/push-client.conf
