{% set service = 'mongodb' %}

/usr/bin/wd-service.sh:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/conf/wd-service.sh
        - mode: 755
        - makedirs: True

/etc/cron.d/wd-{{service}}:
    file.managed:
        - contents: |
             PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin
             * * * * * root /usr/bin/wd-service.sh {{ service }} 3 600 >/dev/null 2>&1
        - mode: 644
        - require:
            - file: /usr/bin/wd-service.sh

