{% set prefix = '/usr/local' %}

yasmagent-instance-getter:
    file.managed:
        - name: {{ prefix }}/yasmagent/mdb_mongodb_getter.py
        - template: jinja
        - source: salt://{{ slspath }}/conf/yasm-agent.getter.py
        - makedirs: True
        - mode: 755
{% if salt['pillar.get']('data:use_yasmagent', True) %}
        - require:
            - pkg: yasmagent-packages

yasmagent-packages:
    pkg.installed:
        - pkgs:
            - yandex-yasmagent: 2.400-20200121
        - require:
            - pkgrepo: common-stable-all

yasmagent-init:
    file.managed:
        - name: /etc/init.d/yasmagent
        - template: jinja
        - source: salt://{{ slspath }}/conf/yasm-agent.init
        - mode: 755
        - require:
            - pkg: yasmagent-packages

yasmagent-default-config:
    file.managed:
        - name: /etc/default/yasmagent
        - template: jinja
        - source: salt://{{ slspath }}/conf/yasm-agent.default
        - mode: 644

yasmagent-restart:
    service:
        - running
        - enable: true
        - name: yasmagent
        - watch:
            - file: yasmagent-instance-getter
            - file: yasmagent-default-config
            - file: yasmagent-init
{% else %}
        - require:
            - pkg: yandex-yasmagent

yandex-yasmagent:
    pkg.purged
{% endif %}
