/usr/local/yandex/mongodb/create_users.py:
    file.managed:
        - template: jinja
        - source: salt://components/mongodb30/create_users.py
        - makedirs: True
        - mode: 755

{% set admin = salt['pillar.get']('data:users:admin') %}
{% for port in admin.get('ports', [27017]) %}
create-admin-user-{{port}}:
    cmd.run:
        - name: '/usr/local/yandex/mongodb/create_users.py --user=admin --password={{admin.get('password', 'admin')}} --roles root --uri "mongodb://localhost:{{port}}" --db admin'
        - stateful: 
            - test_name: '/usr/local/yandex/mongodb/create_users.py --test --user=admin --password={{admin.get('password', 'admin')}} --roles root --uri "mongodb://localhost:{{port}}" --db admin'
        - require: 
            - file: /usr/local/yandex/mongodb/create_users.py
{% endfor %}

{% for name, props in salt['pillar.get']('data:users').items() %}
{% for port in props.get('ports', [27017]) %}
{% for db in props.get('dbs', ['admin']) %}
add-{{name}}-{{port}}-{{db}}-{{props.get('roles')|join('-')}}:
    cmd.run:
        - name: '/usr/local/yandex/mongodb/create_users.py --user={{name}} --password={{props.get('password', name)}} --roles {{props.get('roles')|join(' ')}} --uri "mongodb://admin:{{admin.get('password')}}@localhost:{{port}}/?authSource=admin" --db {{db}}'
        - stateful: 
            - test_name: '/usr/local/yandex/mongodb/create_users.py --test --user={{name}} --password={{props.get('password', name)}} --roles {{props.get('roles')|join(' ')}} --uri "mongodb://admin:{{admin.get('password')}}@localhost:{{port}}/?authSource=admin" --db {{db}}'
        - require: 
            - file: /usr/local/yandex/mongodb/create_users.py
{% endfor %}
{% endfor %}
{% endfor %}
