{% set env = salt['pillar.get']('yandex:environment', 'prod') %}
include:
    - components.repositories.yum.mongodb.mongodb30

{% set mongodb_version = salt['pillar.get']('data:mongodb_version', '3.0.12-1') %}

mongodb-30:
    pkg.installed:
        - pkgs:
            - mongodb-org-server: {{ mongodb_version }}
            - mongodb-org-shell: {{ mongodb_version }}
            - mongodb-org-tools: {{ mongodb_version }}
            - numactl: '2.0.9-2.el6'
        - require:
            - pkgrepo: mongodb30

