{% set env = salt['pillar.get']('yandex:environment', 'prod') %}
include:
    - components.repositories.yum.mongodb.mongodb30

{% set mongodb_version = salt['pillar.get']('data:mongodb_version', '3.0.12-1') %}

mongos-30:
    pkg.installed:
        - pkgs:
            - mongodb-org-mongos: {{ mongodb_version }}
            - mongodb-org-shell: {{ mongodb_version }}
            - numactl: '2.0.7-8.el6'
        - require:
            - pkgrepo: mongodb30

/etc/init.d/mongos:
    file.managed:
        - template: jinja
        - source: salt://components/mongodb30/rhel/init.d/mongos
        - mode: 755
