/etc/sysctl.d:
    file.directory:
        - user: root
        - group: root
        - mode: 755

/etc/sysctl.d/mongodb.conf:
    file.managed:
        - template: jinja
        - source: salt://components/mongodb30/conf/sysctl-mongodb.conf
        - mode: 644
    cmd.wait:
        - name: sysctl -p /etc/sysctl.d/mongodb.conf
        - watch:
            - file: /etc/sysctl.d/mongodb.conf

{% set thp_file = '/sys/kernel/mm/redhat_transparent_hugepage/enabled' %}
{% if salt['grains.get']('os') == 'Ubuntu' %}
{% set thp_file = '/sys/kernel/mm/transparent_hugepage/enabled' %}
{% endif %}

disable_THP:
    cmd.run:
        - name: 'echo never > {{ thp_file }}'
        - unless:
            - "fgrep '[never]' {{ thp_file }}"

{% set thd_file = '/sys/kernel/mm/redhat_transparent_hugepage/defrag' %}
{% if salt['grains.get']('os') == 'Ubuntu' %}
{% set thd_file = '/sys/kernel/mm/transparent_hugepage/defrag' %}
{% endif %}

disable_THP_defrag:
    cmd.run:
        - name: 'echo never > {{ thd_file }}'
        - unless:
            - "fgrep '[never]' {{ thd_file }}"
