{% set env = salt['pillar.get']('yandex:environment', 'prod') %}
{% set mongodb_version = salt['pillar.get']('data:mongodb_version', '3.0.12') %}
include:
    - components.repositories.apt.mongodb

mongodb-30:
    pkg.installed:
        - order: 1
        - pkgs:
            - mongodb-org-server: {{ mongodb_version }}
            - mongodb-org-shell: {{ mongodb_version }}
            - mongodb-org-tools: {{ mongodb_version }}
            - numactl: '2.0.9~rc5-1ubuntu3.14.04.2'
            - python-pymongo: '3.0.3-yandex1'
            - python-bson: '3.0.3-yandex1'

/etc/init/mongodb.conf:
    file.managed:
        - template: jinja
        - source: salt://components/mongodb30/ubuntu/init/mongodb.conf
        - mode: 644

shutdown-mongod:
    cmd.run:
        - name: 'mongo --port 27017 --eval "db.shutdownServer()" admin'
        - unless:
            - "stat /etc/init/mongod.conf.disabled"

disable-mongod:
    cmd.run:
        - name: 'mv /etc/init/mongod.conf /etc/init/mongod.conf.disabled'
        - unless:
            - "stat /etc/init/mongod.conf.disabled"

mongodb-service:
  service.running:
    - enable: True
    - name: mongodb
    - watch:
      - pkg: mongodb-30
