{% set env = salt['pillar.get']('yandex:environment', 'prod') %}

{% set mongodb_version = salt['pillar.get']('data:mongodb_version', '3.0.12') %}

mongos-30:
    pkg.installed:
        - order: 1
        - pkgs:
            - mongodb-org-mongos: {{ mongodb_version }}
            - mongodb-org-shell: {{ mongodb_version }}
            - numactl: '2.0.9~rc5-1ubuntu3.14.04.2'

/etc/init/mongos.conf:
    file.managed:
        - template: jinja
        - source: salt://components/mongodb30/ubuntu/init/mongos.conf
        - mode: 644
