#!/bin/bash

exec 2>&- # close stderr

CRIT=20000
WARN=1000

status_cmd="sudo /usr/sbin/rabbitmqctl list_queues -p /abook"

queue=$(${status_cmd} | awk '$2 ~ /[0-9]+/ && $1 !~ /pidbox|stubborn_update_index/ {sum+=$2} END {print int(sum)}')

die () {
    echo "$1;$2"
    exit 0
}

if [ "x$queue" != "x" ]
then 
    if [ $queue -ge $CRIT ]
    then
        die 2 "${queue}"
    elif [ $queue -ge $WARN ]
    then
        die 1 "${queue}"
    else
        die 0 "${queue}"
    fi
else
    die 1 "no queue stats available"
fi
