#!/bin/bash

exec 2>&- # close stderr

CRIT=1000
WARN=900

status_cmd="sudo /usr/sbin/rabbitmqctl status"

die () {
    echo "$1;$2"
    exit 0
}

sock_limit=$(${status_cmd} | awk -F',' '/sockets_limit/ {print int($2)}')
sock_used=$(${status_cmd} | awk -F',' '/sockets_used/ {print int($2)}')

free=$((${sock_limit}-${sock_used}))

if [ "x$free" != "x" ]
then 
    if [ $free -ge $CRIT ];
    then
        die 0 "${free} left"
    else 
        die 2 "${free} left"
    fi
else
    die 1 "no stats available"
fi
