{% from "components/clickhouse/map.jinja" import template with context %}
include:
    - components.monrun2

monrun-ch-backup-sudoers:
    file.recurse:
        - name: /etc/sudoers.d
        - file_mode: '0440'
        - template: jinja
        - source: salt://{{ slspath }}/sudoers.d
        - include_empty: True
        - watch_in:
            - cmd: monrun-jobs-update

monrun-ch-backup-scripts:
    file.recurse:
        - name: /usr/local/yandex/monitoring
        - file_mode: '0755'
        - template: jinja
        - source: salt://{{ slspath }}/scripts
        - include_empty: True
        - require:
            - file: monrun-ch-backup-sudoers
        - watch_in:
            - cmd: monrun-jobs-update

{% if not template %}
monrun-ch-backup-confs:
    file.recurse:
        - name: /etc/monrun/conf.d
        - file_mode: '0644'
        - template: jinja
        - source: salt://{{ slspath }}/conf.d
        - include_empty: True
        - require:
            - file: monrun-ch-backup-scripts
        - watch_in:
            - cmd: monrun-jobs-update
{% endif %}
