{% from "components/monrun2/clickhouse/map.jinja" import ch_system_queues_cfg with context %}
include:
    - components.monrun2

monrun-clickhouse-scripts:
    file.recurse:
        - name: /usr/local/yandex/monitoring
        - file_mode: '0755'
        - template: jinja
        - source: salt://{{ slspath }}/scripts
        - include_empty: True
        - watch_in:
            - cmd: monrun-jobs-update
        - require:
            - pkg: monrun-clickhouse-packages

monrun-clickhouse-confs:
    file.recurse:
        - name: /etc/monrun/conf.d
        - file_mode: '0644'
        - template: jinja
        - source: salt://{{ slspath }}/conf.d
        - include_empty: True
        - watch_in:
            - cmd: monrun-jobs-update

monrun-clickhouse-sudoers:
    file.recurse:
        - name: /etc/sudoers.d
        - file_mode: '0640'
        - template: jinja
        - source: salt://{{ slspath }}/sudoers.d
        - include_empty: True
        - watch_in:
            - cmd: monrun-jobs-update

monrun-clickhouse-packages:
    pkg.installed:
        - pkgs:
            - python3.5: 3.5.2-3yandex2
            - python3-requests
            - python3-yaml
            - python3-openssl
            - python3-pip
        - reload_modules: true

python3-humanfriendly:
    cmd.run:
        - name: python3.5 -m pip install humanfriendly==4.6
        - unless: python3.5 -m pip freeze | grep -F 'humanfriendly==4.6'
        - require:
            - pkg: monrun-clickhouse-packages

/etc/monitoring/ch_system_queues.yaml:
    file.managed:
        - contents: |
            {{ ch_system_queues_cfg | yaml(False) | indent(12) }}
        - mode: 644
        - user: monitor
        - group: monitor
        - makedirs: True
