#!/usr/bin/env bash

die () {
    echo "$1;$2"
    exit 0
}

while getopts "w:c:" OPTION
do
    case $OPTION in
        w)
            WARN_LIMIT="$OPTARG"
        ;;
        c)
            CRIT_LIMIT="$OPTARG"
        ;;
    esac
done

warn_limit=${WARN_LIMIT:-'300'}
crit_limit=${CRIT_LIMIT:-'600'}

ch_replication_lag=`sudo -u clickhouse clickhouse-client --connect_timeout 1 -q 'SELECT max(absolute_delay) FROM system.replicas' 2>/dev/null`

if [ "$?" -ne "0" ] ; then
    die 1 "Could not get replication lag"
fi

if [ -z "${ch_replication_lag}" ]; then
    die 0 "OK"
fi

if [ "${ch_replication_lag}" -gt "$crit_limit" ]; then
    die 2 "${ch_replication_lag} seconds"
elif [ "${ch_replication_lag}" -gt "$warn_limit" ]; then
    die 1 "${ch_replication_lag} seconds"
else
    die 0 "OK"
fi

