#!/usr/bin/env bash

die () {
    echo "$1;$2"
    exit 0
}

ch_client="`which clickhouse-client --connect_timeout 1`"

ch_ro=`${ch_client} -q 'SELECT database, table \
                      FROM system.replicas \
                      WHERE is_readonly OR is_session_expired;' 2>/dev/null | tr '\t\n' '.;'`


if [[ -n ${ch_ro} ]]; then
    die 2 "Readonly replica tables: ${ch_ro}"
else
    die 0 "OK"
fi
