monrun-common-pkgs:
    pkg.installed:
        - pkgs:
            - config-monitoring-network-load: '0.15'

monrun-common-scripts:
    file.recurse:
        - name: /usr/local/yandex/monitoring
        - file_mode: '0755'
        - template: jinja
        - source: salt://{{ slspath }}/scripts
        - include_empty: True
        - watch_in:
            - cmd: monrun-jobs-update
        - require:
            - pkg: yamail-monrun-common

monrun-common-confs:
    file.recurse:
        - name: /etc/monrun/conf.d
        - file_mode: '0644'
        - template: jinja
        - source: salt://{{ slspath }}/conf.d
        - include_empty: True
        - watch_in:
            - cmd: monrun-jobs-update
        - require:
            - pkg: yamail-monrun-common

monrun-common-sudoers:
    file.recurse:
        - name: /etc/sudoers.d
        - file_mode: '0440'
        - template: jinja
        - source: salt://{{ slspath }}/sudoers.d
        - include_empty: True
        - watch_in:
            - cmd: monrun-jobs-update
        - require:
            - pkg: yamail-monrun-common

{% if not salt['pillar.get']('data:report_to_graphite', True) %}
monrun-disable-graphite-check:
    file.managed:
        - name: /etc/monrun/conf.d/graphite_sender.conf
        - template: jinja
        - source: salt://{{ slspath + '/graphite_sender.conf' }}
        - watch_in:
            - cmd: monrun-jobs-update
{% endif %}

/etc/cron.d/snaked:
    file.absent

{% set cron_jobs = [
                    'juggler-client'
                   ]
%}

{% for job in cron_jobs %}
/etc/cron.d/{{ job }}:
    file.managed:
        - template: jinja
        - source: salt://{{ slspath }}/cron.d/{{ job }}
        - mode: 644
{% endfor %}
