#!/bin/bash
#
# Provides: graphite_sender

set -e

while getopts "w:d:" OPTION
do
    case $OPTION in
        w)
            WARN_LIMIT="$OPTARG"
        ;;
        d)
            DEAD_TIME="$OPTARG"
        ;;
    esac
done

warn_limit=${WARN_LIMIT:-1}
dead_time=${DEAD_TIME:-600}

die() {
    echo "$1;$2"
    exit 0
}

mon_file=/tmp/graphite-sender-monitoring
format=plain

if [ ! -f $mon_file ]
then
    mon_file=/tmp/yabs-graphite-sender-monitoring
    format=json
    if [ ! -f $mon_file ]
    then
        die 1 'graphite-sender monitoring file missing'
    fi
fi

MON_TS=$(stat -c %Y $mon_file)
CUR_TS=$(date +%s)
if [ "$format" = "plain" ]
then
    SUCC=$(grep -v \# $mon_file |tail -n1 |awk '{print $3};')
else
    SUCC=$(grep -Po '"sucess_srv":.*?,' $mon_file |cut -d\  -f2 |cut -d, -f1)
fi
DELTA=$(( CUR_TS - MON_TS ))

if [[ "$SUCC" = "" ]]
then
    SUCC=0
fi

if (( DELTA > dead_time ))
then
    die 2 "No sends for $DELTA seconds"
elif (( SUCC <= warn_limit ))
then
    die 1 "Less than $warn_limit sends ok"
else
    die 0 "OK"
fi
