#!/bin/sh

while getopts "l:" OPTION
do
    case $OPTION in
        l)
            LOG_FILE="$OPTARG"
        ;;
    esac
done

log_file=${LOG_FILE:-/var/log/mcelog}

die () {
    echo "$1;$2"
    exit 0
}

if [ -f /usr/local/sbin/autodetect_environment ] ; then
    is_virtual_host=0
    . /usr/local/sbin/autodetect_environment >/dev/null 2>&1 || true
    if [ "$is_virtual_host" -eq 1 ] ; then
        die 0 "OK"
    fi
fi

if grep 'model name' /proc/cpuinfo | grep -q 'KVM'
then
    die 0 "OK"
elif sudo grep /var/log/dmesg -e 'Booting paravirtualized kernel on KVM' -q 2>/dev/null
then
    die 0 "OK"
fi

if [ -f "$log_file" ]
then
    NOW=$(date +%s)
    HOUR_AGO=$(( NOW - 3600 ))
    DAY_AGO=$(( NOW - 3600 * 24 ))

    err_code=0
    total=0

    for i in $(grep 'TIME ' /var/log/mcelog | awk '{print $2};')
    do
        if [ "$i" -gt "$HOUR_AGO" ]
        then
            err_code=2
            total=$(( total + 1 ))
        elif [ "$i" -gt "$DAY_AGO" ]
        then
            if [ "$err_code" = "0" ]
            then
                err_code=1
            fi
            total=$(( total + 1 ))
        fi
    done

    if [ "$err_code" = "0" ]
    then
        die 0 "OK"
    else
        die "$err_code" "$total errors"
    fi
else
    die 1 "$log_file not found"
fi
